<?php
// Set content type to JSON
header('Content-Type: application/json');

// Database connection parameters
$servername = "localhost";
$username = "root";
$password = "";
$database = "mirror_notifications";

// Check if the required parameters are set
if (
    isset(
        $_POST['notificationId'],
        $_POST['currentUserId'],
        $_POST['receiverId'],
        $_POST['packageName'],
        $_POST['appOnBool']
    )
) {
    // Create connection
    $conn = new mysqli($servername, $username, $password, $database);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Sanitize user input
    $notificationId = mysqli_real_escape_string($conn, $_POST['notificationId']);
    $currentUserId = mysqli_real_escape_string($conn, $_POST['currentUserId']);
    $receiverId = mysqli_real_escape_string($conn, $_POST['receiverId']);
    $packageName = mysqli_real_escape_string($conn, $_POST['packageName']);
    // Convert the string representation of Boolean to actual Boolean
    $appOnBool = filter_var($_POST['appOnBool'], FILTER_VALIDATE_BOOLEAN);

    // Check if the combination of notificationId, currentUserId, receiverId, and packageName already exists
    $checkQuery = "SELECT * FROM `packagesnotification` WHERE 
                    `notificationId`='$notificationId' AND 
                    `currentUserId`='$currentUserId' AND 
                    `receiverId`='$receiverId' AND 
                    `packageName`='$packageName'";
    $checkResult = $conn->query($checkQuery);

    if ($checkResult->num_rows > 0) {
        // The combination already exists, perform an update
        $updateQuery = "UPDATE `packagesnotification` 
                        SET `appOnBool`='$appOnBool' 
                        WHERE 
                        `notificationId`='$notificationId' AND 
                        `currentUserId`='$currentUserId' AND 
                        `receiverId`='$receiverId' AND 
                        `packageName`='$packageName'";
        if ($conn->query($updateQuery) === TRUE) {
            echo json_encode(array("message" => "Record updated successfully"));
        } else {
            echo json_encode(array("error" => "Error updating record: " . $conn->error));
        }
    } else {
        // The combination doesn't exist, perform an insert
        $insertQuery = "INSERT INTO `packagesnotification` 
                        (`notificationId`, `currentUserId`, `receiverId`, `packageName`, `appOnBool`) 
                        VALUES ('$notificationId', '$currentUserId', '$receiverId', '$packageName', '$appOnBool')";
        if ($conn->query($insertQuery) === TRUE) {
            echo json_encode(array("message" => "Record inserted successfully"));
        } else {
            echo json_encode(array("error" => "Error inserting record: " . $conn->error));
        }
    }

    // Close the database connection
    $conn->close();
} else {
    echo json_encode(array("error" => "Missing parameters"));
}
?>
